***********************************************************************
*** Figure F1: In and out-of-sample ROCs ***
***********************************************************************
clear all 
set more off
use "$dataPath\Data"
do "$codePath\Transforming_variables"
cd "$outputFigures" 

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2


* ROC based on Column (1) in Table 2
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id, robust cluster(period)
predict pis1

gen pmod1 = .
set more off
forvalues i = 1(1)20 {
	logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id if country_id != `i', robust cluster(period)
	predict p`i' if country_id == `i'
	replace pmod1 = p`i' if country_id == `i' & pmod1 == . 
	drop p`i'
	}
	
preserve
* Panel a)
roccomp crisis4_12 pis1 pcredit_gdp_gap
roccomp crisis4_12 pmod1 pcredit_gdp_gap
roccurve crisis4_12 pis1 pmod1 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.8647***" 2 "Out-of-sample, AUROC = 0.7049**" 3 "Credit to GDP gap, AUROC = 0.7635/0.7482") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) 
restore
graph export Model1_rolling_roc.pdf, replace

* ROC based on Column (2) in Table 2
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"
cd "$outputFigures" 
set more off
drop if country == "DNK"  || country == "GRC" ||  country == "PRT" 
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id, robust cluster(period)
predict pis2, p

gen pmod2 = .
set more off
forvalues i = 1(1)17 {
	logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id if country_id != `i', robust cluster(period)
	predict p`i' if country_id == `i'
	replace pmod2 = p`i' if country_id == `i' & pmod2 == . 
	drop p`i'
	}
	
preserve
* Panel b)
roccomp crisis4_12 pis2 pcredit_gdp_gap
roccomp crisis4_12 pmod2 pcredit_gdp_gap
roccurve crisis4_12 pis2 pmod2 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.8790***" 2 "Out-of-sample, AUROC = 0.7454" 3 "Credit to GDP gap, AUROC = 0.7530/0.7219") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) 
restore
graph export Model2_rolling_roc.pdf, replace


* ROC based on Column (3) in Table 2
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"
cd "$outputFigures" 
set more off
drop if country == "DNK" || country == "GRC" || country == "PRT" || country == "AUT" || country == "CAN" 

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id, robust cluster(period)
predict pis3, p

gen pmod3 = .
set more off
forvalues i = 1(1)15 {
	logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id if country_id != `i', robust cluster(period)
	predict p`i' if country_id == `i'
	replace pmod3 = p`i' if country_id == `i' & pmod3 == . 
	drop p`i'
	}
	
preserve
* Panel c)
roccomp crisis4_12 pis3 pcredit_gdp_gap
roccomp crisis4_12 pmod3 pcredit_gdp_gap
roccurve crisis4_12 pis3 pmod3 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.9044***" 2 "Out-of-sample, AUROC = 0.8274***" 3 "Credit to GDP gap, AUROC = 0.7491/0.6684") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) 
restore
graph export Model3_rolling_roc.pdf, replace

* ROC based on Column (4) in Table 2
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"
cd "$outputFigures" 
set more off
drop if country == "DNK" || country == "GRC" ||  country == "PRT" || country == "AUT" || country == "CAN" || country == "GBR" || country == "AUS"

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
predict pis4, p

gen pcred4 = .
gen pmod4 = .
set more off
forvalues i = 1(1)13 {
	logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap equity_assets i.country_id if country_id != `i', robust cluster(period)
	predict p`i' if country_id == `i'
	replace pmod4 = p`i' if country_id == `i' & pmod4 == . 
	drop p`i' 	
	}
	
preserve
* Panel d)
roccomp crisis4_12 pis4 pcredit_gdp_gap
roccomp crisis4_12 pmod4 pcredit_gdp_gap
roccurve crisis4_12 pis4 pmod4 pcredit_gdp_gap , title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.9187***" 2 "Out-of-sample, AUROC = 0.6697*" 3 "Credit to GDP gap, AUROC = 0.7539/0.6052") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) 
restore
graph export Model4_rolling_roc.pdf, replace

